<div class="row">
    <div class="col-md-12">
        <div class="profile-sidebar">
            <div class="portlet light profile-sidebar-portlet ">
                <div class="profile-userpic">
                    <img src="{{ $user_profile->presenter()->avatar(750) }}" class="img-responsive" alt=""> 
                </div>
                <div class="profile-usertitle">
                    <div class="profile-usertitle-name"> {{ $user_profile->first_name }} {{ $user_profile->last_name }} </div>
                </div>
                <div class="profile-usermenu"></div>
            </div>
        </div>
        <div class="profile-content">
            <div class="row">
                <div class="col-md-12">
                    <div class="portlet light ">
                        <div class="portlet-title tabbable-line">
                            <div class="caption caption-md">
                                <i class="icon-globe theme-font hide"></i>
                                <span class="caption-subject font-blue-madison bold uppercase">Profile Account</span>
                            </div>
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#tab_1_1" data-toggle="tab">Personal Info</a>
                                </li>
                                @if(!Config::get('acl_base.use_gravatar'))
                                    <li>
                                        <a href="#tab_1_2" data-toggle="tab">Change Avatar</a>
                                    </li>
                                @endif
                                <li>
                                    <a href="#tab_1_3" data-toggle="tab">Change Password</a>
                                </li>
                            </ul>
                        </div>
                        <div class="portlet-body">
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab_1_1">
                                    {{ Form::model($user_profile, [
                                        'method' => 'PATCH',
                                        'url' => ['user_profile', $user_profile->id],
                                        'id' => 'user_profile', 'role' => 'form',
                                    ]) }}
                                        {{ Form::hidden('user_profile', 0) }}
                                        @include('laravel-authentication-acl::admin.user.user-info')
                                        @include('laravel-authentication-acl::admin.user.company-profile')
                                        <div class="margiv-top-10">
                                            {{ Form::submit('Save Changes', ['class' => 'btn green']) }}
                                            <a href="javascript:;" class="btn default"> Cancel </a>
                                        </div>
                                    {{ Form::close() }}
                                </div>
                                @if(!Config::get('acl_base.use_gravatar'))
                                    <div class="tab-pane" id="tab_1_2">
                                        @include('laravel-authentication-acl::admin.user.partials.avatar_upload')
                                    </div>
                                @endif
                                <div class="tab-pane" id="tab_1_3">
                                    @include('laravel-authentication-acl::admin.user.change-password')
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    jQuery(document).ready(function() 
    {
        mnreHub.init();
        
        @if (Session::has('flash_message'))
                toastr_call(1, "{{ Session::get('flash_message') }}");
        @endif
    });
</script>                        