<table class="table table-striped table-bordered table-hover datatable">
    <thead>
        <tr>
            <th>Email</th>
            <th>First Name</th>
            <th>Last Name</th>
            <th>Active</th>
            <th>Last Login</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach($users as $user)
            <tr>
                <td>{{ $user->email }}</td>
                <td>{{ $user->first_name }}</td>
                <td>{{ $user->last_name }}</td>
                <td>
                    @if($user->activated)
                      <i class="fa fa-circle user-active"></i>
                    @else
                      <i class="fa fa-circle-o user-inactive"></i>
                    @endif
                </td>
                <td>{{ $user->last_login ? $user->last_login : 'not logged yet.' }}</td>
                <td>
                    @if(!$user->protected)
                        <a href="{{ URL::route('users.edit', ['id' => $user->id]) }}" class="ajaxify"><i class="fa fa-edit"></i></a>
                        <a href="{{ url('/users/'.$user->id.'/user_balance_history') }}" class="ajaxify"><i class="fa fa-history"></i></a>
<!--                        <a href="javascript:;" id="{{ $user->id }}" class="delete"><i class="fa fa-trash-o"></i></a>-->
                    @else
                        <i class="fa fa-remove"></i>
                        <i class="fa fa-remove"></i>
                    @endif
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
