<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of the routes that are handled
| by your application. Just tell Laravel the URIs it should respond
| to using a Closure or controller method. Build something great!
|
*/

Route::group(['middleware' => ['web']], function () 
{   
    $path = '';
    $route = parse_url(URL::previous());
    
    if(array_key_exists('path', $route))
    {
        $path = $route['path'];
    }else
    {
        $path = Request::path();
    }
    
    if (Request::is('admin*') || $path == '/admin') 
    {
        $url = '/admin/login';
    }else
    {
        $url = '/login';
    }
    
    Route::post('authenticate', [
        'uses' => 'ResponseController@authenticate'
    ]);
    
    Route::get('terms', [
        'uses' => 'ResponseController@terms'
    ]);
    
    Route::post('transactions/paypal_ipn', [
        'uses' => 'ResponseController@paypalStore'
    ]);

    Route::post('transactions/paypal_thanks', [
        'uses' => 'ResponseController@paypalThanks'
    ]);
/*    
    Route::get('transactions/paypal_cancel', [
        'uses' => 'ResponseController@paypalCancel'
    ]);
*/    
    Route::get('admin/logout', function () 
    {
        $authenticator = \App::make('authenticator');
        $authenticator->logout();
        return redirect('admin/login');
    });
    
    Route::group(['middleware' => ['admin_logged:'.$url, 'can_see']], function ()
    {
        
/***********************************Template***********************************/

        Route::get('/', function () 
        {
            return view('layouts.app');
        });
                
        Route::get('/admin', function () 
        {
//            $authentication = \App::make('authentication_helper');
            
            if(userGroup() == 'agent')
            {
                redirect('/')->send();
            }
            return view('laravel-authentication-acl::admin.layouts.app');
        });
        
        Route::post('transactions/instant_credit', [
            'middleware' => 'has_perm:_superadmin,_instant-credit',
            'uses' => 'ResponseController@instantCreditStore'
        ]);

        Route::post('transactions/stripe', [
            'middleware' => 'has_perm:_superadmin,_instant-credit',
            'uses' => 'ResponseController@stripeStore'
        ]);

        Route::group(['middleware' => ['ajax']], function ()
        {
/**********************************Dashboard***********************************/

            Route::get('dashboard', [
                'as' => 'dashboard',
                'uses' => 'DashboardController@index'
            ]);

/*********************************User Modules*********************************/        

/*********************************Attractions**********************************/

            Route::get('transactions/attractions', [
                'as' => 'attractions',
                'middleware' => 'has_perm:_superadmin,_attractions',
                'uses' => 'TransactionsController@attractions'
            ]);
            
/***********************************Banking************************************/

            Route::get('transactions/transaction', [
                'as' => 'banking',
                'middleware' => 'has_perm:_superadmin,_banking',
                'uses' => 'TransactionsController@banking'
            ]);

            Route::post('transactions/transaction', [
                'middleware' => 'has_perm:_superadmin,_banking',
                'uses' => 'TransactionsController@bankingStore'
            ]);

/****************************Courier/Cargo Service*****************************/

            Route::get('transactions/courier_service', [
                'as' => 'courier_service',
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'TransactionsController@courierService'
            ]);

            Route::post('transactions/courier_service_detail', [
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'TransactionsController@courierServiceDetail'
            ]);

            Route::post('transactions/courier_service', [
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'TransactionsController@courierServiceStore'
            ]);
            
            Route::get('transactions/courier_info', [
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'TransactionsController@courierInfo'
            ]);
/*
            Route::get('transactions/{printer}/courier_print_info', [
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'TransactionsController@courierPrintInfo'
            ]);

            Route::get('transactions/{service_name}/courier_cover_info', [
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'TransactionsController@courierCoverInfo'
            ]);

            Route::get('transactions/{service_name}/courier_parcel_info', [
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'TransactionsController@courierParcelInfo'
            ]);
*/            
            Route::get('transactions/courier_address', [
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'TransactionsController@courierAddress'
            ]);
            
            Route::post('transactions/courier_address', [
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'TransactionsController@courierAddressStore'
            ]);
            
            Route::get('transactions/filter_courier_addresses', [
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'TransactionsController@filterCourierAddresses'
            ]);
            
            Route::get('transactions/courier_user_profile', [
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'TransactionsController@courierUserProfile'
            ]);
            
            Route::get('transactions/cargo_service_cover_page', [
                'as' => 'cargo_service_cover_page',
                'middleware' => 'has_perm:_superadmin,_cargo-services',
                'uses' => 'TransactionsController@cargoServiceCoverPage'
            ]);
            
            Route::get('transactions/get_delivery_countries', [    
                'middleware' => 'has_perm:_superadmin,_cargo-services',
                'uses' => 'TransactionsController@getDeliveryCountries'
            ]);
            
            Route::get('transactions/get_cargo_services', [    
                'middleware' => 'has_perm:_superadmin,_cargo-services',
                'uses' => 'TransactionsController@getCargoServices'
            ]);
            
            Route::get('transactions/get_cargo_rate', [    
                'middleware' => 'has_perm:_superadmin,_cargo-services',
                'uses' => 'TransactionsController@getCargoRate'
            ]);
            
/*******************************Customer Module********************************/        

            Route::get('customers', [
                'as' => 'customers',
                'middleware' => 'has_perm:_superadmin,_customer',
                'uses' => 'CustomersController@index'
            ]);

            Route::get('customers/get_customer_data', [
                'middleware' => 'has_perm:_superadmin,_customer,_customer-invoice',
                'uses' => 'CustomersController@getCustomerData'
            ]);

            Route::get('customers/create', [
                'middleware' => 'has_perm:_superadmin,_customer',
                'uses' => 'CustomersController@create'
            ]);

            Route::post('customers', [
                'middleware' => 'has_perm:_superadmin,_customer',
                'uses' => 'CustomersController@store'
            ]);

            Route::get('customers/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_customer',
                'uses' => 'CustomersController@edit'
            ]);

            Route::patch('customers/{id}', [
                'middleware' => 'has_perm:_superadmin,_customer',
                'uses' => 'CustomersController@update'
            ]);
    /*        
            Route::post('customers/update_status', [
                'middleware' => 'has_perm:_superadmin,_customer',
                'uses' => 'CustomersController@updateStatus'
            ]);*/

/***************************Customer Invoice Module****************************/        

            Route::get('customers/customer_invoice', [
                'as' => 'customer_invoice',
                'middleware' => 'has_perm:_superadmin,_customer-invoice',
                'uses' => 'CustomersController@customerInvoice'
            ]);

            Route::post('customers/customer_invoice', [
                'middleware' => 'has_perm:_superadmin,_customer-invoice',
                'uses' => 'CustomersController@customerInvoiceStore'
            ]);

            Route::get('customers/customer_receipt', [
                'as' => 'customer_receipt',
                'middleware' => 'has_perm:_superadmin,_customer-invoice',
                'uses' => 'CustomersController@customerReceipt'
            ]);

            Route::get('customers/get_custom_data', [
                'middleware' => 'has_perm:_superadmin,_customer-invoice',
                'uses' => 'CustomersController@getCustomData'
            ]);

/********************************Instant Credit********************************/

            Route::get('transactions/instant_credit', [
                'as' => 'instant_credit',
                'middleware' => 'has_perm:_superadmin,_instant-credit',
                'uses' => 'TransactionsController@instantCredit'
            ]);

    //        Route::get('transactions/stripe', [
    //            'middleware' => 'has_perm:_superadmin,_instant-credit',
    //            'uses' => 'TransactionsController@stripe'
    //        ]);

            Route::get('transactions/instant_credit_stripe_receipt', [
                'middleware' => 'has_perm:_superadmin,_instant-credit',
                'uses' => 'TransactionsController@instantCreditStripeReceipt'
            ]);

/*****************************International Top-Up*****************************/

            Route::get('transactions/international_topup', [
                'as' => 'international_topup',
                'middleware' => 'has_perm:_superadmin,_international-topup',
                'uses' => 'TransactionsController@internationalTopup'
            ]);
            
/************************************Hotels*************************************/

            Route::get('transactions/hotels', [
                'as' => 'hotels',
                'middleware' => 'has_perm:_superadmin,_hotels',
                'uses' => 'TransactionsController@hotels'
            ]);
            
/********************************MNR e-Services********************************/

            Route::get('transactions/mnr_services', [
                'as' => 'mnr_services',
                'middleware' => 'has_perm:_superadmin,_mnr-services,_mnr-marketing',
                'uses' => 'TransactionsController@mnrServices'
            ]);

            Route::get('transactions/mnr_service_detail', [
                'as' => 'mnr_service_detail',
                'middleware' => 'has_perm:_superadmin,_mnr-services,_mnr-marketing',
                'uses' => 'TransactionsController@mnrServiceDetail'
            ]);

            Route::post('transactions/mnr_service', [
                'middleware' => 'has_perm:_superadmin,_mnr-services,_mnr-marketing',
                'uses' => 'TransactionsController@mnrServiceStore'
            ]);

/*********************************Mobile Order*********************************/

            Route::get('transactions/mobile_order', [
                'as' => 'mobile_order',
                'middleware' => 'has_perm:_superadmin,_mobiles',
                'uses' => 'TransactionsController@mobileOrder'
            ]);

            Route::post('transactions/mobile_order', [
                'middleware' => 'has_perm:_superadmin,_mobiles',
                'uses' => 'TransactionsController@mobileOrderStore'
            ]);
    /*        
            Route::get('transactions/{brand_id}/get_models', [
                'middleware' => 'has_perm:_superadmin,_mobile-order',
                'uses' => 'TransactionsController@getModels'
            ]);
    */        
            Route::post('transactions/get_product_detail', [
                'middleware' => 'has_perm:_superadmin,_mobiles',
                'uses' => 'TransactionsController@getProductDetail'
            ]);

/***********************************Reports************************************/
            
            Route::get('reports', [
                'as' => 'reports',
                'uses' => 'ReportsController@index'
            ]);
            
            Route::get('reports/banking_list', [
                'as' => 'banking_list',
                'middleware' => 'has_perm:_superadmin,_banking',
                'uses' => 'ReportsController@bankingList'
            ]);
            
            Route::get('banking/get_data', [
                'middleware' => 'has_perm:_superadmin,_banking',
                'uses' => 'ReportsController@getBankingData'
            ]);
            
            Route::get('reports/courier_services', [
                'as' => 'courier_services_list',
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'ReportsController@courierList'
            ]);

            Route::get('courier_services/get_data', [
                'middleware' => 'has_perm:_superadmin,_courier-services,_cargo-services',
                'uses' => 'ReportsController@getCourierData'
            ]);
            
            Route::get('reports/mobile_order', [
                'as' => 'mobile_order_report',
                'middleware' => 'has_perm:_superadmin,_mobiles',
                'uses' => 'ReportsController@mobileOrder'
            ]);

            Route::get('mobile_order/get_data', [
                'middleware' => 'has_perm:_superadmin,_mobiles',
                'uses' => 'ReportsController@getMobileOrderData'
            ]);
            
            Route::get('reports/sales_report', [
                'as' => 'sales_report',
                'middleware' => 'has_perm:_superadmin,_customer-invoice',
                'uses' => 'ReportsController@salesReport'
            ]);

            Route::get('sales_report/get_data', [
                'middleware' => 'has_perm:_superadmin,_customer-invoice',
                'uses' => 'ReportsController@getSalesReportData'
            ]);
            
            Route::get('reports/sim_order', [
                'as' => 'sim_order_report',
                'middleware' => 'has_perm:_superadmin,_sim',
                'uses' => 'ReportsController@simOrder'
            ]);
            
            Route::get('sim_order/get_data', [
                'middleware' => 'has_perm:_superadmin,_sim',
                'uses' => 'ReportsController@getSimOrderData'
            ]);
            
            Route::get('reports/topup', [
                'as' => 'topup_report',
                'middleware' => 'has_perm:_superadmin,_top-up,_calling-cards',
                'uses' => 'ReportsController@topup'
            ]);

            Route::get('reports/topup_list', [
                'as' => 'topup_list',
                'middleware' => 'has_perm:_superadmin,_top-up,_calling-cards',
                'uses' => 'ReportsController@topupList'
            ]);

            Route::get('topup/get_data', [
                'middleware' => 'has_perm:_superadmin,_top-up,_calling-cards',
                'uses' => 'ReportsController@getTopupData'
            ]);
            
            Route::get('reports/unlocking_mobile_status', [
                'as' =>'unlocking_mobile_status',
                'middleware' => 'has_perm:_superadmin,_unlocking-mobiles',
                'uses' => 'ReportsController@unlockingMobileStatus'
            ]);
            
            Route::get('reports/unlocking_mobile_list', [
                'as' =>'unlocking_mobile_list',
                'middleware' => 'has_perm:_superadmin,_unlocking-mobiles',
                'uses' => 'ReportsController@unlockingMobileList'
            ]);
            
            Route::get('unlocking_mobile/get_data', [
                'middleware' => 'has_perm:_superadmin,_unlocking-mobiles',
                'uses' => 'ReportsController@getUnlockingMobileData'
            ]);
            
            Route::get('users/get_user_data', [
                'middleware' => 'has_perm:_superadmin,_banking,_mobiles,_sim,_top-up,_calling-cards,_unlocking-mobiles,_sale-agent-sim-allotment,_agent-sim-allotment',
                'uses' => 'ReportsController@getUserData'
            ]);

/*******************************Settings Module********************************/        

            Route::get('settings', [
                'as' => 'settings', 
                'middleware' => 'has_perm:_superadmin,_settings',
                'uses' => 'SettingsController@index'
            ]);

            Route::get('modules/create', [
                'middleware' => 'has_perm:_superadmin,_settings',
                'uses' => 'SettingsController@create'
            ]);

            Route::post('modules', [
                'middleware' => 'has_perm:_superadmin,_settings',
                'uses' => 'SettingsController@store'
            ]);

            Route::get('modules/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_settings',
                'uses' => 'SettingsController@edit'
            ]);

            Route::patch('modules/{id}', [
                'middleware' => 'has_perm:_superadmin,_settings',
                'uses' => 'SettingsController@update'
            ]);

            Route::get('custom_fields/create', [
                'middleware' => 'has_perm:_superadmin,_settings',
                'uses' => 'SettingsController@createCustomField'
            ]);

            Route::post('custom_fields', [
                'middleware' => 'has_perm:_superadmin,_settings',
                'uses' => 'SettingsController@storeCustomField'
            ]);

            Route::get('custom_fields/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_settings',
                'uses' => 'SettingsController@editCustomField'
            ]);

            Route::patch('custom_fields/{id}', [
                'middleware' => 'has_perm:_superadmin,_settings',
                'uses' => 'SettingsController@updateCustomField'
            ]);

            Route::post('custom_fields/update_status', [
                'middleware' => 'has_perm:_superadmin,_settings',
                'uses' => 'SettingsController@updateStatus'
            ]);

            Route::patch('company_profile/{id}', [
                'middleware' => 'has_perm:_superadmin,_user-editor',
                'uses' => 'SettingsController@updateCompanyProfile'
            ]);
            
            Route::get('user_profile', [
                'as' => 'user_profile',
                'middleware' => 'has_perm:_superadmin,_user-editor',
                'uses' => 'SettingsController@userProfile'
            ]);
            
            Route::patch('user_profile/{id}', [
                'middleware' => 'has_perm:_superadmin,_user-editor',
                'uses' => 'SettingsController@updateUserProfile'
            ]);
            
            Route::post('settings/update_page_refresh_time', [
                'uses' => 'SettingsController@updatePageRefreshTime'
            ]);
            
/**********************************SIM Order***********************************/

            Route::get('transactions/sim_cover_page', [
                'as' => 'sim_cover_page',
                'middleware' => 'has_perm:_superadmin,_sim',
                'uses' => 'TransactionsController@simCoverPage'
            ]);

            Route::get('transactions/sim_order', [
                'as' => 'sim_order',
                'middleware' => 'has_perm:_superadmin,_sim',
                'uses' => 'TransactionsController@simOrder'
            ]);

            Route::post('transactions/sim_order', [
                'middleware' => 'has_perm:_superadmin,_sim',
                'uses' => 'TransactionsController@simOrderStore'
            ]);

            Route::get('transactions/commission_scheme', [
                'as' => 'commission_scheme',
                'middleware' => 'has_perm:_superadmin,_sim',
                'uses' => 'TransactionsController@commissionScheme'
            ]);

/************************************Ticket************************************/

            Route::get('transactions/ticket', [
                'as' => 'ticket',
                'middleware' => 'has_perm:_superadmin,_ticket',
                'uses' => 'TransactionsController@ticket'
            ]);

            Route::get('customers/get_quotes', [
                'middleware' => 'has_perm:_superadmin,_ticket',
                'uses' => 'CustomersController@getQuotes'
            ]);
            
            Route::post('customers/quote_to_invoice', [
                'middleware' => 'has_perm:_superadmin,_ticket',
                'uses' => 'CustomersController@quoteToInvoice'
            ]);
            
/************************************Tours*************************************/

            Route::get('transactions/tours', [
                'as' => 'tours',
                'middleware' => 'has_perm:_superadmin,_tours',
                'uses' => 'TransactionsController@tours'
            ]);
            
/*****************************Top-Up/Calling Cards*****************************/

            Route::get('transactions/topup', [
                'as' => 'topup',
                'middleware' => 'has_perm:_superadmin,_top-up,_calling-cards',
                'uses' => 'TransactionsController@topup'
            ]);

            Route::post('transactions/topup', [
                'middleware' => 'has_perm:_superadmin,_top-up,_calling-cards',
                'uses' => 'TransactionsController@topupStore'
            ]);

            Route::get('transactions/{category_id}/get_products', [
                'middleware' => 'has_perm:_superadmin,_top-up,_calling-cards',
                'uses' => 'TransactionsController@getProducts'
            ]);

            Route::get('transactions/{product_id}/get_product_amounts', [
                'middleware' => 'has_perm:_superadmin,_top-up,_calling-cards',
                'uses' => 'TransactionsController@getProductAmounts'
            ]);

            Route::get('transactions/receipt', [
                'as' => 'receipt',
                'middleware' => 'has_perm:_superadmin,_top-up,_calling-cards',
                'uses' => 'TransactionsController@receipt'
            ]);
    /*        
            Route::get('response/print_topup_receipt', [
                'as' => 'print_receipt',
                'middleware' => 'has_perm:_superadmin,_top-up',
                'uses' => 'ResponseController@printTopupreceipt'
            ]);
    */        
            Route::get('transactions/get_balance', [
                'middleware' => 'has_perm:_superadmin,_top-up,_calling-cards',
                'uses' => 'TransactionsController@getBalance'
            ]);

/*******************************Unlocking Mobile*******************************/

            Route::get('transactions/unlocking_mobile_cover_page', [
                'as' => 'unlocking_mobile_cover_page',
                'middleware' => 'has_perm:_superadmin,_unlocking-mobiles',
                'uses' => 'TransactionsController@unlockingMobileCoverPage'
            ]);
            
            Route::get('transactions/unlocking_mobile', [
                'as' => 'unlocking_mobile',
                'middleware' => 'has_perm:_superadmin,_unlocking-mobiles',
                'uses' => 'TransactionsController@unlockingMobile'
            ]);

            Route::get('transactions/unlocking_mobile_detail', [
                'as' => 'unlocking_mobile_detail',
                'middleware' => 'has_perm:_superadmin,_unlocking-mobiles',
                'uses' => 'TransactionsController@unlockingMobileDetail'
            ]);

            Route::post('transactions/unlocking_mobile', [
                'middleware' => 'has_perm:_superadmin,_unlocking-mobiles',
                'uses' => 'TransactionsController@unlockingMobileStore'
            ]);

            Route::post('transactions/cancel_unlocking_mobile_order', [
                'middleware' => 'has_perm:_superadmin,_unlocking-mobiles',
                'uses' => 'TransactionsController@cancelUnlockingMobileOrder'
            ]);
            
/*********************************Admin Modules*********************************/        

/*********************************Admin Module*********************************/

            Route::get('admin/dashboard', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@dashboard'
            ]);

            Route::post('admin/banking_approved', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@bankingApproved'
            ]);

            Route::get('admin/mobile_order_list', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@mobileOrderList'
            ]);

            Route::get('admin/{transaction_id}/mobile_order_detail', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@mobileOrderDetail'
            ]);

            Route::post('admin/mobile_delivered', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@mobileDelivered'
            ]);

            Route::get('admin/sim_order_list', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@simOrderList'
            ]);

            Route::get('admin/{transaction_id}/sim_order_detail', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@simOrderDetail'
            ]);

            Route::post('admin/sim_delivered', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@simDelivered'
            ]);

            Route::post('admin/unlocking_mobile_status_update', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@unlockingMobileStatusUpdate'
            ]);

            Route::get('admin/{id}/unlocking_mobile_detail', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@unlockingMobileDetail'
            ]);
            
            Route::get('users/{user_id}/user_balance_history', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@userBalanceHistory'
            ]);

            Route::get('admin/payment_method_response', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@PaymentMethodResponse'
            ]);
            
            Route::post('admin/courier_status_update', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'AdminController@courierStatusUpdate'
            ]);

/********************************Amounts Module********************************/

            Route::get('amounts', [
                'middleware' => 'has_perm:_superadmin,_amount-view',
                'uses' => 'AmountsController@index'
            ]);

            Route::get('amounts/create', [
                'middleware' => 'has_perm:_superadmin,_amount-create',
                'uses' => 'AmountsController@create'
            ]);

            Route::post('amounts', [
                'middleware' => 'has_perm:_superadmin,_amount-create',
                'uses' => 'AmountsController@store'
            ]);

            Route::get('amounts/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_amount-edit',
                'uses' => 'AmountsController@edit'
            ]);

            Route::patch('amounts/{id}', [
                'middleware' => 'has_perm:_superadmin,_amount-edit',
                'uses' => 'AmountsController@update'
            ]);
            
/*********************************APIs Module**********************************/

            Route::get('apis', [
                'middleware' => 'has_perm:_superadmin,_api-view',
                'uses' => 'ApisController@index'
            ]);

            Route::get('apis/create', [
                'middleware' => 'has_perm:_superadmin,_api-create',
                'uses' => 'ApisController@create'
            ]);

            Route::post('apis', [
                'middleware' => 'has_perm:_superadmin,_api-create',
                'uses' => 'ApisController@store'
            ]);

            Route::get('apis/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_api-edit',
                'uses' => 'ApisController@edit'
            ]);

            Route::patch('apis/{id}', [
                'middleware' => 'has_perm:_superadmin,_api-edit',
                'uses' => 'ApisController@update'
            ]);
            
            Route::post('apis/update_status', [
                'middleware' => 'has_perm:_superadmin,_api-edit',
                'uses' => 'ApisController@updateStatus'
            ]);

/*********************************Banks Module*********************************/        

            Route::get('banks', [
                'middleware' => 'has_perm:_superadmin,_bank-view',
                'uses' => 'BanksController@index'
            ]);

            Route::get('banks/create', [
                'middleware' => 'has_perm:_superadmin,_bank-create',
                'uses' => 'BanksController@create'
            ]);

            Route::post('banks', [
                'middleware' => 'has_perm:_superadmin,_bank-create',
                'uses' => 'BanksController@store'
            ]);

            Route::get('banks/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_bank-edit',
                'uses' => 'BanksController@edit'
            ]);

            Route::patch('banks/{id}', [
                'middleware' => 'has_perm:_superadmin,_bank-edit',
                'uses' => 'BanksController@update'
            ]);

            Route::post('banks/update_status', [
                'middleware' => 'has_perm:_superadmin,_bank-edit',
                'uses' => 'BanksController@updateStatus'
            ]);

/*****************************Bank Accounts Module*****************************/        

            Route::get('bank_accounts', [
                'middleware' => 'has_perm:_superadmin,_bank-account-view',
                'uses' => 'BankAccountsController@index'
            ]);

            Route::get('bank_accounts/create', [
                'middleware' => 'has_perm:_superadmin,_bank-account-create',
                'uses' => 'BankAccountsController@create'
            ]);

            Route::post('bank_accounts', [
                'middleware' => 'has_perm:_superadmin,_bank-account-create',
                'uses' => 'BankAccountsController@store'
            ]);

            Route::get('bank_accounts/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_bank-account-edit',
                'uses' => 'BankAccountsController@edit'
            ]);

            Route::patch('bank_accounts/{id}', [
                'middleware' => 'has_perm:_superadmin,_bank-account-edit',
                'uses' => 'BankAccountsController@update'
            ]);

            Route::post('bank_accounts/update_status', [
                'middleware' => 'has_perm:_superadmin,_bank-account-edit',
                'uses' => 'BankAccountsController@updateStatus'
            ]);

/********************************Brands Module*********************************/

            Route::get('brands', [
                'middleware' => 'has_perm:_superadmin,_brand-view',
                'uses' => 'BrandsController@index'
            ]);

            Route::get('brands/create', [
                'middleware' => 'has_perm:_superadmin,_brand-create',
                'uses' => 'BrandsController@create'
            ]);

            Route::post('brands', [
                'middleware' => 'has_perm:_superadmin,_brand-create',
                'uses' => 'BrandsController@store'
            ]);

            Route::get('brands/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_brand-edit',
                'uses' => 'BrandsController@edit'
            ]);

            Route::patch('brands/{id}', [
                'middleware' => 'has_perm:_superadmin,_brand-edit',
                'uses' => 'BrandsController@update'
            ]);

            Route::post('brands/update_status', [
                'middleware' => 'has_perm:_superadmin,_brand-edit',
                'uses' => 'BrandsController@updateStatus'
            ]);

/****************************Cargo Services Module*****************************/

            Route::get('cargo_services', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-view',
                'uses' => 'CargoServicesController@index'
            ]);

            Route::get('cargo_services/create', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-create',
                'uses' => 'CargoServicesController@create'
            ]);

            Route::post('cargo_services', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-create,',
                'uses' => 'CargoServicesController@store'
            ]);

            Route::get('cargo_services/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-edit',
                'uses' => 'CargoServicesController@edit'
            ]);

            Route::patch('cargo_services/{id}', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-edit',
                'uses' => 'CargoServicesController@update'
            ]);

            Route::post('cargo_services/update_status', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-edit',
                'uses' => 'CargoServicesController@updateStatus'
            ]);

/**************************Cargo Service Rates Module**************************/

            Route::get('cargo_service_rates', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-rate-view',
                'uses' => 'CargoServiceRatesController@index'
            ]);

            Route::get('cargo_service_rates/create', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-rate-create',
                'uses' => 'CargoServiceRatesController@create'
            ]);

            Route::post('cargo_service_rates', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-rate-create,',
                'uses' => 'CargoServiceRatesController@store'
            ]);

            Route::get('cargo_service_rates/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-rate-edit',
                'uses' => 'CargoServiceRatesController@edit'
            ]);

            Route::patch('cargo_service_rates/{id}', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-rate-edit',
                'uses' => 'CargoServiceRatesController@update'
            ]);

            Route::post('cargo_service_rates/update_status', [
                'middleware' => 'has_perm:_superadmin,_cargo-service-rate-edit',
                'uses' => 'CargoServiceRatesController@updateStatus'
            ]);
            
/******************************Categories Module*******************************/

            Route::get('categories', [
                'middleware' => 'has_perm:_superadmin,_category-view',
                'uses' => 'CategoriesController@index'
            ]);

            Route::get('categories/create', [
                'middleware' => 'has_perm:_superadmin,_category-create',
                'uses' => 'CategoriesController@create'
            ]);

            Route::post('categories', [
                'middleware' => 'has_perm:_superadmin,_category-create',
                'uses' => 'CategoriesController@store'
            ]);

            Route::get('categories/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_category-edit',
                'uses' => 'CategoriesController@edit'
            ]);

            Route::patch('categories/{id}', [
                'middleware' => 'has_perm:_superadmin,_category-edit',
                'uses' => 'CategoriesController@update'
            ]);

            Route::post('categories/update_status', [
                'middleware' => 'has_perm:_superadmin,_category-edit',
                'uses' => 'CategoriesController@updateStatus'
            ]);

/********************************Configs Module********************************/

            Route::get('configs', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'ConfigsController@index'
            ]);

            Route::get('configs/create', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'ConfigsController@create'
            ]);

            Route::post('configs', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'ConfigsController@store'
            ]);

            Route::get('configs/{id}/edit', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'ConfigsController@edit'
            ]);

            Route::patch('configs/{id}', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'ConfigsController@update'
            ]);

            Route::post('configs/update_status', [
                'middleware' => 'has_perm:_superadmin',
                'uses' => 'ConfigsController@updateStatus'
            ]);
            
/*****************************MNR Services Module******************************/

            Route::get('mnr_services', [
                'middleware' => 'has_perm:_superadmin,_mnr-service-view,_mnr-marketing-view',
                'uses' => 'MnrServicesController@index'
            ]);

            Route::get('mnr_services/create', [
                'middleware' => 'has_perm:_superadmin,_mnr-service-create,_mnr-marketing-create',
                'uses' => 'MnrServicesController@create'
            ]);

            Route::post('mnr_services', [
                'middleware' => 'has_perm:_superadmin,_mnr-service-create,_mnr-marketing-create',
                'uses' => 'MnrServicesController@store'
            ]);

            Route::get('mnr_services/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_mnr-service-edit,_mnr-marketing-edit',
                'uses' => 'MnrServicesController@edit'
            ]);

            Route::patch('mnr_services/{id}', [
                'middleware' => 'has_perm:_superadmin,_mnr-service-edit,_mnr-marketing-edit',
                'uses' => 'MnrServicesController@update'
            ]);

            Route::post('mnr_services/update_status', [
                'middleware' => 'has_perm:_superadmin,_mnr-service-edit,_mnr-marketing-edit',
                'uses' => 'MnrServicesController@updateStatus'
            ]);

/****************************Mobile Products Module****************************/

            Route::get('mobile_products', [
                'middleware' => 'has_perm:_superadmin,_mobile-product-view',
                'uses' => 'MobileProductsController@index'
            ]);

            Route::get('mobile_products/create', [
                'middleware' => 'has_perm:_superadmin,_mobile-product-create',
                'uses' => 'MobileProductsController@create'
            ]);

            Route::post('mobile_products', [
                'middleware' => 'has_perm:_superadmin,_mobile-product-create',
                'uses' => 'MobileProductsController@store'
            ]);

            Route::get('mobile_products/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_mobile-product-edit',
                'uses' => 'MobileProductsController@edit'
            ]);

            Route::patch('mobile_products/{id}', [
                'middleware' => 'has_perm:_superadmin,_mobile-product-edit',
                'uses' => 'MobileProductsController@update'
            ]);

            Route::post('mobile_products/update_status', [
                'middleware' => 'has_perm:_superadmin,_mobile-product-edit',
                'uses' => 'MobileProductsController@updateStatus'
            ]);

/*******************************Networks Module********************************/

            Route::get('networks', [
                'middleware' => 'has_perm:_superadmin,_network-view',
                'uses' => 'NetworksController@index'
            ]);

            Route::get('networks/create', [
                'middleware' => 'has_perm:_superadmin,_network-create',
                'uses' => 'NetworksController@create'
            ]);

            Route::post('networks', [
                'middleware' => 'has_perm:_superadmin,_network-create,',
                'uses' => 'NetworksController@store'
            ]);

            Route::get('networks/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_network-edit',
                'uses' => 'NetworksController@edit'
            ]);

            Route::patch('networks/{id}', [
                'middleware' => 'has_perm:_superadmin,_network-edit',
                'uses' => 'NetworksController@update'
            ]);

            Route::post('networks/update_status', [
                'middleware' => 'has_perm:_superadmin,_network-edit',
                'uses' => 'NetworksController@updateStatus'
            ]);

/**************************Network Commission Module***************************/

            Route::get('network_commission', [
                'middleware' => 'has_perm:_superadmin,_network-commission-view',
                'uses' => 'NetworkCommissionController@index'
            ]);

            Route::get('network_commission/create', [
                'middleware' => 'has_perm:_superadmin,_network-commission-create',
                'uses' => 'NetworkCommissionController@create'
            ]);

            Route::post('network_commission', [
                'middleware' => 'has_perm:_superadmin,_network-commission-create,',
                'uses' => 'NetworkCommissionController@store'
            ]);

            Route::get('network_commission/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_network-commission-edit',
                'uses' => 'NetworkCommissionController@edit'
            ]);

            Route::patch('network_commission/{id}', [
                'middleware' => 'has_perm:_superadmin,_network-commission-edit',
                'uses' => 'NetworkCommissionController@update'
            ]);

            Route::post('network_commission/update_status', [
                'middleware' => 'has_perm:_superadmin,_network-commission-edit',
                'uses' => 'NetworkCommissionController@updateStatus'
            ]);

            Route::get('network_commission/network_commission_scheme', [
                'middleware' => 'has_perm:_superadmin,_network-commission-scheme-view',
                'uses' => 'NetworkCommissionController@networkCommissionScheme'
            ]);

            Route::post('network_commission/network_commission_scheme', [
                'middleware' => 'has_perm:_superadmin,_network-commission-scheme-create',
                'uses' => 'NetworkCommissionController@networkCommissionSchemeStore'
            ]);

            Route::post('network_commission/edit_network_commission_scheme', [
                'middleware' => 'has_perm:_superadmin,_network-commission-scheme-edit',
                'uses' => 'NetworkCommissionController@networkCommissionSchemeUpdate'
            ]);

            Route::get('network_commission/network_incentive_list', [
                'middleware' => 'has_perm:_superadmin,_network-incentive-view',
                'uses' => 'NetworkCommissionController@networkIncentiveList'
            ]);

            Route::get('network_commission/get_network_incentive_data', [
                'middleware' => 'has_perm:_superadmin,_network-incentive-view',
                'uses' => 'NetworkCommissionController@getNetworkIncentiveData'
            ]);

            Route::post('network_commission/import_network_incentive', [
                'middleware' => 'has_perm:_superadmin,_import-network-incentive',
                'uses' => 'NetworkCommissionController@importNetworkIncentive'
            ]);

            Route::post('network_commission/apply_network_incentive', [
                'middleware' => 'has_perm:_superadmin,_apply-network-incentive',
                'uses' => 'NetworkCommissionController@applyNetworkIncentive'
            ]);

            Route::post('network_commission/pay_network_incentive', [
                'middleware' => 'has_perm:_superadmin,_pay-network-incentive',
                'uses' => 'NetworkCommissionController@payNetworkIncentive'
            ]);

/*******************************Products Module********************************/

            Route::get('products', [
                'middleware' => 'has_perm:_superadmin,_product-view',
                'uses' => 'ProductsController@index'
            ]);

            Route::get('products/create', [
                'middleware' => 'has_perm:_superadmin,_product-create',
                'uses' => 'ProductsController@create'
            ]);

            Route::post('products', [
                'middleware' => 'has_perm:_superadmin,_product-create',
                'uses' => 'ProductsController@store'
            ]);

            Route::get('products/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_product-edit',
                'uses' => 'ProductsController@edit'
            ]);

            Route::patch('products/{id}', [
                'middleware' => 'has_perm:_superadmin,_product-edit',
                'uses' => 'ProductsController@update'
            ]);

            Route::post('products/update_status', [
                'middleware' => 'has_perm:_superadmin,_product-edit',
                'uses' => 'ProductsController@updateStatus'
            ]);

            Route::get('products/{product_id}/get_amount', [    
                'middleware' => 'has_perm:_superadmin,_product-create,_product-edit',
                'uses' => 'ProductsController@getAmount'
            ]);  

/******************************Pin Numbers Module******************************/        

            Route::get('pin_numbers', [
                'middleware' => 'has_perm:_superadmin,_pin-number-view',
                'uses' => 'PinNumbersController@index'
            ]);
            
            Route::get('pin_numbers/get_data', [
                'middleware' => 'has_perm:_superadmin,_pin-number-view',
                'uses' => 'PinNumbersController@getData'
            ]);

            Route::get('pin_numbers_summary', [
                'middleware' => 'has_perm:_superadmin,_pin-number-view',
                'uses' => 'PinNumbersController@pinNumbersSummary'
            ]);
            
            Route::get('pin_numbers/create', [
                'middleware' => 'has_perm:_superadmin,_pin-number-create',
                'uses' => 'PinNumbersController@create'
            ]);

            Route::post('pin_numbers', [
                'middleware' => 'has_perm:_superadmin,_pin-number-create',
                'uses' => 'PinNumbersController@store'
            ]);

            Route::get('pin_numbers/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_pin-number-edit',
                'uses' => 'PinNumbersController@edit'
            ]);

            Route::patch('pin_numbers/{id}', [
                'middleware' => 'has_perm:_superadmin,_pin-number-edit',
                'uses' => 'PinNumbersController@update'
            ]);

            Route::post('pin_numbers/update_status', [
                'middleware' => 'has_perm:_superadmin,_pin-number-edit',
                'uses' => 'PinNumbersController@updateStatus'
            ]);

/********************************SIM Allotment*********************************/

            Route::get('sale_agent_sim_allotment',[
                'middleware' => 'has_perm:_superadmin,_sale-agent-sim-allotment',
                'uses' => 'SimInformationsController@saleAgentSimAllotment'
            ]);

            Route::post('sale_agent_sim_allotment',[
                'middleware' => 'has_perm:_superadmin,_sale-agent-sim-allotment',
                'uses' => 'SimInformationsController@saleAgentSimAllotmentStore'
            ]);
            
            Route::get('agent_sim_allotment',[
                'middleware' => 'has_perm:_superadmin,_agent-sim-allotment',
                'uses' => 'SimInformationsController@agentSimAllotment'
            ]);

            Route::post('agent_sim_allotment',[
                'middleware' => 'has_perm:_superadmin,_agent-sim-allotment',
                'uses' => 'SimInformationsController@agentSimAllotmentStore'
            ]);

            Route::get('sim_informations/{type}/{ssn}/get_ssn_info', [
                'middleware' => 'has_perm:_superadmin,_sale-agent-sim-allotment,_agent-sim-allotment',
                'uses' => 'SimInformationsController@getSsnInfo'
            ]);

/*******************************SIM Information********************************/

            Route::get('sim_informations',[
                'middleware' => 'has_perm:_superadmin,_sim-information-view',
                'uses' => 'SimInformationsController@index'
            ]);

            Route::get('sim_informations/{id}/view_data', [
                'middleware' => 'has_perm:_superadmin,_sim-information-view',
                'uses' => 'SimInformationsController@show'
            ]);

//            Route::get('sim_informations/view_data', [
//                'middleware' => 'has_perm:_superadmin,_sim-information-view',
//                'uses' => 'SimInformationsController@viewData'
//            ]);

//            Route::get('sim_informations/edit_data', [
//                'middleware' => 'has_perm:_superadmin,_sim-information-view',
//                'uses' => 'SimInformationsController@editData'
//            ]);

            Route::get('sim_informations/create', [
                'middleware' => 'has_perm:_superadmin,_sim-information-create',
                'uses' => 'SimInformationsController@create'
            ]);

            Route::post('sim_informations', [
                'middleware' => 'has_perm:_superadmin,_sim-information-create',
                'uses' => 'SimInformationsController@store'
            ]);

            Route::get('sim_informations/{network_id}/get_products', [
                'middleware' => 'has_perm:_superadmin,_sim-information-create',
                'uses' => 'SimInformationsController@getSimProducts'
            ]);

/*********************************SIM Products*********************************/

            Route::get('sim_products',[
                'middleware' => 'has_perm:_superadmin,_sim-product-view',
                'uses' => 'SimProductsController@index'
            ]);

            Route::get('sim_products/create', [
                'middleware' => 'has_perm:_superadmin,_sim-product-create',
                'uses' => 'SimProductsController@create'
            ]);

            Route::post('sim_products', [
                'middleware' => 'has_perm:_superadmin,_sim-product-create',
                'uses' => 'SimProductsController@store'
            ]);

            Route::get('sim_products/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_sim-product-edit',
                'uses' => 'SimProductsController@edit'
            ]);

            Route::patch('sim_products/{id}', [
                'middleware' => 'has_perm:_superadmin,_sim-product-edit',
                'uses' => 'SimProductsController@update'
            ]);

/*******************************Services Module********************************/

            Route::get('services', [
                'middleware' => 'has_perm:_superadmin,_service-view',
                'uses' => 'ServicesController@index'
            ]);
            
            Route::get('services/get_data', [
                'middleware' => 'has_perm:_superadmin,_service-view',
                'uses' => 'ServicesController@getData'
            ]);
            
            Route::get('services/create', [
                'middleware' => 'has_perm:_superadmin,_service-create',
                'uses' => 'ServicesController@create'
            ]);

            Route::post('services', [
                'middleware' => 'has_perm:_superadmin,_service-create',
                'uses' => 'ServicesController@store'
            ]);
            
            Route::post('auto_generated_service', [
                'middleware' => 'has_perm:_superadmin,_service-create',
                'uses' => 'ServicesController@autoGeneratedService'
            ]);
            
            Route::get('services/{id}/edit', [
                'middleware' => 'has_perm:_superadmin,_service-edit',
                'uses' => 'ServicesController@edit'
            ]);

            Route::patch('services/{id}', [
                'middleware' => 'has_perm:_superadmin,_service-edit',
                'uses' => 'ServicesController@update'
            ]);

            Route::post('services/update_price', [
                'middleware' => 'has_perm:_superadmin,_service-edit',
                'uses' => 'ServicesController@updatePrice'
            ]);
            
            Route::post('services/update_status', [
                'middleware' => 'has_perm:_superadmin,_service-edit',
                'uses' => 'ServicesController@updateStatus'
            ]);
            
            Route::get('services/{api_id}/get_api_categories', [
                'middleware' => 'has_perm:_superadmin,_service-create,_service-edit',
                'uses' => 'ServicesController@getApiCategories'
            ]);
            
            Route::get('services/get_api_services', [
                'middleware' => 'has_perm:_superadmin,_service-create,_service-edit',
                'uses' => 'ServicesController@getApiServices'
            ]);
            
/********AM*******************SIM Reports*******************AM***********/

            Route::get('sim_reports',[
                'as' =>'sim_reports',
                //'middleware' => 'has_perm:_superadmin,_customer',
                'uses' => 'SimReportsController@index'
            ]);

            Route::get('sim_reports_detail',[
                'as' =>'sim_reports-view',
                'middleware' => 'has_perm:_superadmin,_customer,_top-up',
                'uses' => 'SimReportsController@reports'
            ]);


/********AM*******************SIM Check Sum*******************AM***********/

            Route::get('sim_checksum', [
                'as'=>'sim_checksum',
                'middleware' => 'has_perm:_superadmin,_sim-allotment',
                'uses' => 'SimInformationsController@getSimInformations'
            ]);

            Route::post('sim_checksum_info', [
                'as'=>'sim_checksum_info',
                'middleware' => 'has_perm:_superadmin,_sim-allotment',
                'uses' => 'SimInformationsController@getCliChecksum'
            ]);

        });
    });    
});        
